***************************
*** After the Uprisings ***
***************************

use "Arab Barometer IRT.dta", clear

*Algeria
reg econperformance wave if country==1
estimates store Algeria1
reg govtperformance wave if country==1
estimates store Algeria2
reg demoseffective2 wave if country==1
estimates store Algeria3

*Egypt
reg econperformance wave if country==5
estimates store Egypt1
reg govtperformance wave if country==5
estimates store Egypt2
reg demoseffective2 wave if country==5
estimates store Egypt3

*Iraq
reg econperformance wave if country==7
estimates store Iraq1
reg govtperformance wave if country==7
estimates store Iraq2
reg demoseffective2 wave if country==7
estimates store Iraq3

*Jordan
reg econperformance wave if country==8
estimates store Jordan1
reg govtperformance wave if country==8
estimates store Jordan2
reg demoseffective2 wave if country==8
estimates store Jordan3

*Lebanon
reg econperformance wave if country==10
estimates store Lebanon1
reg govtperformance wave if country==10
estimates store Lebanon2
reg demoseffective2 wave if country==10
estimates store Lebanon3

*Palestine
reg econperformance wave if country==15
estimates store Palestine1
reg govtperformance wave if country==15
estimates store Palestine2
reg demoseffective2 wave if country==15
estimates store Palestine3

*Sudan
reg econperformance wave if country==19
estimates store Sudan1
reg govtperformance wave if country==19
estimates store Sudan2
reg demoseffective2 wave if country==19
estimates store Sudan3

*Tunisia
reg econperformance wave if country==21
estimates store Tunisia1
reg govtperformance wave if country==21
estimates store Tunisia2
reg demoseffective2 wave if country==21
estimates store Tunisia3

*Yemen
reg econperformance wave if country==22
estimates store Yemen1
reg govtperformance wave if country==22
estimates store Yemen2
reg demoseffective2 wave if country==22
estimates store Yemen3


grstyle init
grstyle set imesh, compact
graph set window fontface "Garamond"


coefplot (Algeria1, mlabels2(wave=8 "Algeria*")) ///
		(Egypt1, mlabels2(wave=8 "Egypt*")) ///
		(Iraq1, mlabels2(wave=8 "Iraq*")) ///
		(Jordan1, mlabels2(wave=8 "Jordan")) ///
		(Lebanon1, mlabels2(wave=8 "Lebanon")) ///
		(Palestine1, mlabels2(wave=8 "Palestine")) ///
		(Sudan1, mlabels2(wave=8 "Sudan*")) ///
		(Tunisia1, mlabels2(wave=8 "Tunisia*")) ///
		(Yemen1, mlabels2(wave=8 "Yemen")), ///
		vertical drop(_cons) ytitle(W3 - W2, tstyle(size(medsmall))) yline(0, lpattern(dash)) legend(off) ///
		coeflabel(wave = " ") graphregion(color(white)) bgcolor(white) ///
		subtitle(Economic Performance, tstyle(size(medsmall))) mcolor(black) mlabcolor(black) ///
		ciopts(lcolor(black)) name(econ)
		
		
coefplot (Algeria2, mlabels2(wave=8 "Algeria*")) ///
		(Egypt2, mlabels2(wave=8 "Egypt*")) ///
		(Iraq2, mlabels2(wave=8 "Iraq*")) ///
		(Jordan2, mlabels2(wave=8 "Jordan*")) ///
		(Lebanon2, mlabels2(wave=8 "Lebanon")) ///
		(Palestine2, mlabels2(wave=8 "Palestine")) ///
		(Sudan2, mlabels2(wave=8 "Sudan*")) ///
		(Tunisia2, mlabels2(wave=8 "Tunisia*")) ///
		(Yemen2, mlabels2(wave=8 "Yemen*")), ///
		vertical drop(_cons) ytitle(W3 - W2, tstyle(size(medsmall))) yline(0, lpattern(dash)) legend(off) ///
		coeflabel(wave = " ") graphregion(color(white)) bgcolor(white) ///
		subtitle(Government Performance, tstyle(size(medsmall))) mcolor(black) mlabcolor(black) ///
		ciopts(lcolor(black)) name(government)


coefplot (Algeria3, mlabels2(wave=8 "Algeria*")) ///
		(Egypt3, mlabels2(wave=8 "Egypt*")) ///
		(Iraq3, mlabels2(wave=8 "Iraq")) ///
		(Jordan3, mlabels2(wave=8 "Jordan")) ///
		(Lebanon3, mlabels2(wave=8 "Lebanon")) ///
		(Palestine3, mlabels2(wave=8 "Palestine")) ///
		(Sudan3, mlabels2(wave=8 "Sudan*")) ///
		(Tunisia3, mlabels2(wave=8 "Tunisia*")) ///
		(Yemen3, mlabels2(wave=8 "Yemen")), ///
		vertical drop(_cons) ytitle(W3 - W2, tstyle(size(medsmall))) yline(0, lpattern(dash)) legend(off) ///
		coeflabel(wave = " ") graphregion(color(white)) bgcolor(white) ///
		subtitle(Consequences of Democracy, tstyle(size(medsmall))) mcolor(black) mlabcolor(black) ///
		ciopts(lcolor(black)) name(consequences)

graph combine econ government consequences, rows(3) graphregion(color(white))
graph export Figure2.png, width(1000) replace
graph drop econ government consequences

estimates clear
graph set window fontface default

